import type { Metadata } from "next";
import { createMetadata } from "@/lib/metadata";
import { getSiteInfo } from "@/lib/data";

export async function generateMetadata(): Promise<Metadata> {
  const siteInfo = getSiteInfo();
  return createMetadata({
    title: `About ${siteInfo.siteName}`,
    description:
      `Discover ${siteInfo.siteName}'s mission to provide responsible betting recommendations and insights for UK players.`,
    path: "/about",
  });
}

export default function AboutPage() {
  // Read siteInfo at runtime (not bundled)
  const siteInfo = getSiteInfo();
  
  return (
    <div className="space-y-16">
      <section className="relative overflow-hidden rounded-3xl bg-gradient-to-br from-slate-900 via-slate-800 to-slate-900 px-8 py-10 text-white shadow-2xl sm:px-12 sm:py-12">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(120,119,198,0.15),transparent_50%)]" />
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_70%_80%,rgba(59,130,246,0.1),transparent_50%)]" />
        <div className="relative space-y-6 text-center">
          <span className="inline-flex items-center gap-2 rounded-full border border-white/20 bg-white/10 px-4 py-2 text-xs font-semibold uppercase tracking-[0.15em] text-white/90 backdrop-blur-sm">
            <span className="relative flex h-2 w-2">
              <span className="absolute inline-flex h-full w-full animate-ping rounded-full bg-emerald-400 opacity-75" />
              <span className="relative inline-flex h-2 w-2 rounded-full bg-emerald-500" />
            </span>
            About Us
          </span>
          <h1 className="text-4xl font-bold leading-[1.1] tracking-tight text-white sm:text-6xl lg:text-7xl">
            About {siteInfo.siteName}
          </h1>
          <p className="mx-auto max-w-3xl text-lg leading-relaxed text-white/90 sm:text-xl">
            {siteInfo.siteName} exists to connect UK bettors with transparent,
            responsibly-promoted casino and sportsbook offers. Our team analyses
            each operator&apos;s compliance history, bonus terms, and mobile UX to
            make sure you can run Google Ads campaigns with confidence.
          </p>
        </div>
      </section>

      <section className="grid gap-8 sm:grid-cols-3">
        {[
          {
            title: "Our Mission",
            description:
              "Champion safe and responsible gaming while helping partners ship best-in-class acquisition journeys.",
            gradient: "from-blue-500 to-blue-600",
            iconSvg: (
              <svg className="h-7 w-7" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2}>
                <path strokeLinecap="round" strokeLinejoin="round" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z" />
              </svg>
            ),
          },
          {
            title: "Compliance First",
            description:
              "We audit creatives and landing pages against UKGC guidance and Google Ads policies before they make the cut.",
            gradient: "from-emerald-500 to-emerald-600",
            iconSvg: (
              <svg className="h-7 w-7" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2}>
                <path strokeLinecap="round" strokeLinejoin="round" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
              </svg>
            ),
          },
          {
            title: "Data-Led Testing",
            description:
              "Performance dashboards and conversion data (gclid-linked) feed back into weekly partner reviews.",
            gradient: "from-purple-500 to-purple-600",
            iconSvg: (
              <svg className="h-7 w-7" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2}>
                <path strokeLinecap="round" strokeLinejoin="round" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
              </svg>
            ),
          },
        ].map((item) => (
          <article
            key={item.title}
            className="group relative flex min-h-[320px] flex-col overflow-hidden rounded-3xl border border-white/20 bg-white/10 backdrop-blur-sm p-8 text-center shadow-lg transition-all duration-500 ease-out hover:-translate-y-2 hover:scale-[1.02] hover:border-white/30 hover:bg-white/15 hover:shadow-xl"
          >
            <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(120,119,198,0.1),transparent_50%)]" />
            <div className="absolute inset-0 bg-[radial-gradient(circle_at_70%_80%,rgba(59,130,246,0.05),transparent_50%)]" />
            <div className={`relative z-10 mx-auto mb-6 flex h-16 w-16 items-center justify-center rounded-2xl bg-gradient-to-br ${item.gradient} text-white shadow-lg transition-transform duration-500 group-hover:scale-110`}>
              {item.iconSvg}
            </div>
            <h2 className="relative z-10 mb-4 text-2xl font-extrabold text-white">
              {item.title}
            </h2>
            <p className="relative z-10 text-sm leading-relaxed text-white/80">{item.description}</p>
          </article>
        ))}
      </section>

      <section className="relative space-y-8 overflow-hidden rounded-3xl border border-white/20 bg-white/10 backdrop-blur-sm p-8 shadow-lg sm:p-12">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(120,119,198,0.1),transparent_50%)]" />
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_70%_80%,rgba(59,130,246,0.05),transparent_50%)]" />
        <div className="relative space-y-4 text-center">
          <h2 className="relative z-10 text-3xl font-bold tracking-tight text-white sm:text-4xl">Our Commitment</h2>
          <p className="relative z-10 mx-auto max-w-2xl text-base leading-relaxed text-white/80 sm:text-lg">
            We&apos;re dedicated to creating a trusted platform that connects UK bettors with the best betting opportunities while maintaining the highest standards of compliance and transparency.
          </p>
        </div>
        <div className="relative grid gap-6 md:grid-cols-2">
          <div className="group relative flex min-h-[240px] flex-col overflow-hidden rounded-2xl border border-white/20 bg-white/10 backdrop-blur-sm p-8 text-center shadow-lg transition-all duration-500 ease-out hover:-translate-y-1 hover:scale-[1.02] hover:border-white/30 hover:bg-white/15 hover:shadow-xl">
            <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(120,119,198,0.1),transparent_50%)]" />
            <div className="relative z-10 mx-auto mb-4 flex h-14 w-14 items-center justify-center rounded-xl bg-gradient-to-br from-blue-500 to-blue-600 text-white shadow-lg transition-transform duration-500 group-hover:scale-110">
              <svg className="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2}>
                <path strokeLinecap="round" strokeLinejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                <path strokeLinecap="round" strokeLinejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
              </svg>
            </div>
            <h3 className="relative z-10 mb-3 text-xl font-extrabold text-white">
              Trust & Transparency
            </h3>
            <p className="relative z-10 text-sm leading-relaxed text-white/80">
              Every partner is carefully vetted for licensing, bonus terms clarity, and user experience quality. We believe in full transparency about operator status and offer details.
            </p>
          </div>
          <div className="group relative flex min-h-[240px] flex-col overflow-hidden rounded-2xl border border-white/20 bg-white/10 backdrop-blur-sm p-8 text-center shadow-lg transition-all duration-500 ease-out hover:-translate-y-1 hover:scale-[1.02] hover:border-white/30 hover:bg-white/15 hover:shadow-xl">
            <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(120,119,198,0.1),transparent_50%)]" />
            <div className="relative z-10 mx-auto mb-4 flex h-14 w-14 items-center justify-center rounded-xl bg-gradient-to-br from-emerald-500 to-emerald-600 text-white shadow-lg transition-transform duration-500 group-hover:scale-110">
              <svg className="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2}>
                <path strokeLinecap="round" strokeLinejoin="round" d="M13 10V3L4 14h7v7l9-11h-7z" />
              </svg>
            </div>
            <h3 className="relative z-10 mb-3 text-xl font-extrabold text-white">
              Performance Excellence
            </h3>
            <p className="relative z-10 text-sm leading-relaxed text-white/80">
              Our platform is optimized for speed, mobile responsiveness, and conversion. We track performance metrics to continuously improve the betting partner experience.
            </p>
          </div>
        </div>
      </section>
    </div>
  );
}
