import { NextRequest, NextResponse } from 'next/server';
import { incrementClick, getClicks } from '@/lib/clicks';

export async function POST(request: NextRequest) {
  try {
    const { partnerName }: { partnerName: string } = await request.json();
    
    if (!partnerName) {
      return NextResponse.json(
        { error: 'Partner name is required' },
        { status: 400 }
      );
    }
    
    incrementClick(partnerName);
    
    return NextResponse.json({ success: true });
  } catch (error) {
    return NextResponse.json(
      { error: 'Failed to track click' },
      { status: 500 }
    );
  }
}

export async function GET() {
  try {
    const clicks = getClicks();
    return NextResponse.json(clicks);
  } catch (error) {
    return NextResponse.json(
      { error: 'Failed to get clicks' },
      { status: 500 }
    );
  }
}

