import type { Metadata } from "next";
import { createMetadata } from "@/lib/metadata";

export function generateMetadata(): Metadata {
  return createMetadata({
    title: "Disclaimer",
    description:
      "Disclaimer regarding betting partner offers, terms and conditions, and responsible gambling practices.",
    path: "/disclaimer",
  });
}

export default function DisclaimerPage() {
  return (
    <div className="space-y-16">
      <section className="relative overflow-hidden rounded-3xl bg-gradient-to-br from-slate-900 via-slate-800 to-slate-900 px-8 py-10 text-white shadow-2xl sm:px-12 sm:py-12">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(120,119,198,0.15),transparent_50%)]" />
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_70%_80%,rgba(59,130,246,0.1),transparent_50%)]" />
        <div className="relative space-y-6 text-center">
          <span className="inline-flex items-center gap-2 rounded-full border border-white/20 bg-white/10 px-4 py-2 text-xs font-semibold uppercase tracking-[0.15em] text-white/90 backdrop-blur-sm">
            Legal
          </span>
          <h1 className="text-4xl font-bold leading-[1.1] tracking-tight text-white sm:text-6xl lg:text-7xl">
            Disclaimer
          </h1>
          <p className="mx-auto max-w-3xl text-lg leading-relaxed text-white/90 sm:text-xl">
            Important information about our betting partner recommendations and terms of use.
          </p>
        </div>
      </section>

      <section className="space-y-8 rounded-3xl border border-slate-200/80 bg-gradient-to-br from-white via-white to-slate-50/30 p-8 shadow-[0_2px_8px_0_rgb(0,0,0,0.04)] sm:p-12">
        <div className="prose prose-slate max-w-none space-y-6 text-slate-700">
          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">General Information</h2>
            <p className="leading-relaxed">
              BetRanked promotes licensed operators where possible. All betting partner offers, bonuses, and promotions are subject to change and are governed by the terms and conditions of each individual operator. We strive to provide accurate and up-to-date information, but we cannot guarantee the availability or terms of any offer.
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Partner Offers</h2>
            <p className="leading-relaxed">
              All welcome bonuses, promotions, and offers displayed on BetRanked are subject to:
            </p>
            <ul className="list-disc space-y-2 pl-6">
              <li>The terms and conditions of the respective betting operator</li>
              <li>Eligibility requirements set by each operator</li>
              <li>Availability at the time of your registration</li>
              <li>Geographic restrictions and licensing requirements</li>
            </ul>
            <p className="leading-relaxed">
              We recommend reviewing the full terms and conditions on the operator&apos;s website before claiming any offer.
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Licensing Status</h2>
            <p className="leading-relaxed">
              BetRanked displays licensing information for betting partners where available. We make every effort to verify licensing status, but operators may hold licenses from different jurisdictions. It is your responsibility to verify that any operator is licensed and regulated in your jurisdiction before placing bets.
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Affiliate Relationships</h2>
            <p className="leading-relaxed">
              BetRanked maintains affiliate relationships with the betting operators featured on our platform. This means we may receive compensation when users click through and register with these operators. This does not affect our commitment to providing honest, transparent recommendations.
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">No Guarantees</h2>
            <p className="leading-relaxed">
              BetRanked does not guarantee:
            </p>
            <ul className="list-disc space-y-2 pl-6">
              <li>The availability of any specific offer or bonus</li>
              <li>The accuracy of bonus terms or promotional details</li>
              <li>Winning outcomes or betting results</li>
              <li>The performance or reliability of any betting operator</li>
            </ul>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Responsible Gambling</h2>
            <p className="leading-relaxed">
              BetRanked is committed to promoting responsible gambling. We encourage all users to:
            </p>
            <ul className="list-disc space-y-2 pl-6">
              <li>Only gamble with money you can afford to lose</li>
              <li>Set limits on your gambling activities</li>
              <li>Seek help if gambling becomes a problem</li>
              <li>Familiarize yourself with responsible gambling resources</li>
            </ul>
            <p className="leading-relaxed">
              If you need help with problem gambling, please contact organizations such as GamCare, BeGambleAware, or your local support services.
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Age Restrictions</h2>
            <p className="leading-relaxed">
              All betting operators require users to be at least 18 years old (or the legal gambling age in your jurisdiction). BetRanked does not promote gambling to minors. By using our platform, you confirm that you meet the legal age requirements for gambling in your jurisdiction.
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Limitation of Liability</h2>
            <p className="leading-relaxed">
              BetRanked shall not be liable for any losses, damages, or issues arising from:
            </p>
            <ul className="list-disc space-y-2 pl-6">
              <li>Your use of any betting operator&apos;s services</li>
              <li>Changes to offers, bonuses, or terms by operators</li>
              <li>Disputes between you and betting operators</li>
              <li>Technical issues or website downtime</li>
            </ul>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Contact Us</h2>
            <p className="leading-relaxed">
              If you have questions about this disclaimer, please contact us at{" "}
              <a href="mailto:support@betranked.com" className="text-slate-900 font-semibold hover:underline">
                support@betranked.com
              </a>
            </p>
            <p className="text-sm text-slate-500">
              Last updated: {new Date().toLocaleDateString("en-GB", { year: "numeric", month: "long", day: "numeric" })}
            </p>
          </div>
        </div>
      </section>
    </div>
  );
}

