import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";
import { Header } from "@/components/Header";
import { Footer } from "@/components/Footer";
import { BASE_URL } from "@/lib/metadata";
import { getSiteInfo } from "@/lib/data";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
  display: "swap",
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
  display: "swap",
});

export async function generateMetadata(): Promise<Metadata> {
  const siteInfo = getSiteInfo();
  return {
    metadataBase: new URL(BASE_URL),
    title: {
      default: siteInfo.browserTitle || `${siteInfo.siteName} | Trusted Betting Partner Reviews`,
      template: `%s | ${siteInfo.siteName}`,
    },
    description:
      "Compare curated UK partners, explore verified welcome bonuses, and claim offers that meet quality standards.",
    icons: {
      icon: siteInfo.favicon || "/favicon.ico",
      shortcut: siteInfo.favicon || "/favicon.ico",
      apple: "/apple-icon.png",
    },
  };
}

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  // Read siteInfo at runtime for layout
  const siteInfo = getSiteInfo();
  
  return (
    <html lang="en" className={`${geistSans.variable} ${geistMono.variable}`}>
      <body className="min-h-screen text-slate-100 antialiased relative z-10">
        <Header siteInfo={siteInfo} />
        <main className="mx-auto w-full max-w-6xl flex-1 px-4 py-6 sm:px-6 sm:py-12 lg:py-16">{children}</main>
        <Footer siteInfo={siteInfo} />
      </body>
    </html>
  );
}
