import type { Metadata } from "next";
import { createMetadata } from "@/lib/metadata";

export function generateMetadata(): Metadata {
  return createMetadata({
    title: "Privacy Policy",
    description:
      "Privacy policy outlining how we collect, use, and protect your personal information in compliance with GDPR requirements.",
    path: "/privacy",
  });
}

export default function PrivacyPage() {
  return (
    <div className="space-y-16">
      <section className="relative overflow-hidden rounded-3xl bg-gradient-to-br from-slate-900 via-slate-800 to-slate-900 px-8 py-10 text-white shadow-2xl sm:px-12 sm:py-12">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(120,119,198,0.15),transparent_50%)]" />
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_70%_80%,rgba(59,130,246,0.1),transparent_50%)]" />
        <div className="relative space-y-6 text-center">
          <span className="inline-flex items-center gap-2 rounded-full border border-white/20 bg-white/10 px-4 py-2 text-xs font-semibold uppercase tracking-[0.15em] text-white/90 backdrop-blur-sm">
            Legal
          </span>
          <h1 className="text-4xl font-bold leading-[1.1] tracking-tight text-white sm:text-6xl lg:text-7xl">
            Privacy Policy
          </h1>
          <p className="mx-auto max-w-3xl text-lg leading-relaxed text-white/90 sm:text-xl">
            Your privacy is important to us. This policy explains how we collect, use, and protect your information.
          </p>
        </div>
      </section>

      <section className="space-y-8 rounded-3xl border border-slate-200/80 bg-gradient-to-br from-white via-white to-slate-50/30 p-8 shadow-[0_2px_8px_0_rgb(0,0,0,0.04)] sm:p-12">
        <div className="prose prose-slate max-w-none space-y-6 text-slate-700">
          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Information We Collect</h2>
            <p className="leading-relaxed">
              BetRanked collects minimal information necessary to provide our services. We may collect:
            </p>
            <ul className="list-disc space-y-2 pl-6">
              <li>Contact information when you submit a form (name, email address)</li>
              <li>Usage data through anonymized analytics to improve our website</li>
              <li>Technical information such as IP address, browser type, and device information</li>
            </ul>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">How We Use Your Information</h2>
            <p className="leading-relaxed">
              We use the information we collect to:
            </p>
            <ul className="list-disc space-y-2 pl-6">
              <li>Respond to your enquiries and provide customer support</li>
              <li>Improve our website performance and user experience</li>
              <li>Ensure compliance with Google Ads policies and UK gambling regulations</li>
              <li>Analyze website traffic patterns through anonymized data</li>
            </ul>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Data Protection</h2>
            <p className="leading-relaxed">
              We never sell user data. All analytics are anonymised and consent-based to remain compliant with Google Ads policies and GDPR requirements. We implement appropriate technical and organizational measures to protect your personal information.
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Cookies and Tracking</h2>
            <p className="leading-relaxed">
              Our website uses cookies and similar tracking technologies to analyze website traffic and improve user experience. All tracking is anonymized and compliant with Google Ads policies. You can control cookie preferences through your browser settings.
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Third-Party Services</h2>
            <p className="leading-relaxed">
              We may use third-party services for analytics and website functionality. These services are bound by their own privacy policies and are selected for their commitment to data protection and compliance.
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Your Rights</h2>
            <p className="leading-relaxed">
              Under GDPR, you have the right to:
            </p>
            <ul className="list-disc space-y-2 pl-6">
              <li>Access your personal data</li>
              <li>Request correction of inaccurate data</li>
              <li>Request deletion of your data</li>
              <li>Object to processing of your data</li>
              <li>Data portability</li>
            </ul>
            <p className="leading-relaxed">
              To exercise these rights, please contact us at{" "}
              <a href="mailto:support@betranked.com" className="text-slate-900 font-semibold hover:underline">
                support@betranked.com
              </a>
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Changes to This Policy</h2>
            <p className="leading-relaxed">
              We may update this privacy policy from time to time. We will notify you of any changes by posting the new policy on this page and updating the &quot;Last updated&quot; date.
            </p>
          </div>

          <div className="space-y-4">
            <h2 className="text-2xl font-bold text-slate-900">Contact Us</h2>
            <p className="leading-relaxed">
              If you have questions about this privacy policy, please contact us at{" "}
              <a href="mailto:support@betranked.com" className="text-slate-900 font-semibold hover:underline">
                support@betranked.com
              </a>
            </p>
            <p className="text-sm text-slate-500">
              Last updated: {new Date().toLocaleDateString("en-GB", { year: "numeric", month: "long", day: "numeric" })}
            </p>
          </div>
        </div>
      </section>
    </div>
  );
}

