import type { SiteInfo } from "@/types/data";

type FooterProps = {
  siteInfo: SiteInfo;
};

export function Footer({ siteInfo }: FooterProps) {
  return (
    <footer className="border-t border-slate-300/50 bg-gradient-to-br from-slate-900 via-slate-800 to-slate-900">
      <div className="mx-auto flex max-w-6xl flex-col gap-12 px-4 py-16 text-sm sm:flex-row sm:justify-between sm:px-6 lg:gap-16">
        <div className="space-y-4">
          <h3 className="text-lg font-bold text-white">Contact</h3>
          <div className="space-y-3">
            <p>
              <span className="font-semibold text-white/80">Email:</span>{" "}
              <a 
                href={`mailto:${siteInfo.email}`} 
                className="text-white/70 transition-colors hover:text-white hover:underline"
              >
                {siteInfo.email}
              </a>
            </p>
            <p>
              <span className="font-semibold text-white/80">Phone:</span>{" "}
              <a 
                href={`tel:${siteInfo.phone.replace(/\s+/g, "")}`} 
                className="text-white/70 transition-colors hover:text-white hover:underline"
              >
                {siteInfo.phone}
              </a>
            </p>
            <p>
              <span className="font-semibold text-white/80">Address:</span>{" "}
              <span className="text-white/70">{siteInfo.address}</span>
            </p>
          </div>
        </div>
        <div className="space-y-6">
          <div className="space-y-3">
            <h3 className="text-lg font-bold text-white">Compliance</h3>
            <div className="flex gap-4">
              <a 
                href="/privacy" 
                className="text-white/70 transition-colors hover:text-white hover:underline"
              >
                Privacy Policy
              </a>
              <span className="text-white/30">•</span>
              <a 
                href="/disclaimer" 
                className="text-white/70 transition-colors hover:text-white hover:underline"
              >
                Disclaimer
              </a>
            </div>
          </div>
          <section id="privacy" aria-labelledby="privacy-heading" className="space-y-2 text-xs leading-relaxed text-white/60">
            <p id="privacy-heading" className="font-bold uppercase tracking-wider text-white/50">
              Privacy Policy
            </p>
            <p>
              We never sell user data. Analytics are anonymised and consent-based to remain compliant with Google Ads policies.
            </p>
          </section>
          <section id="disclaimer" aria-labelledby="disclaimer-heading" className="space-y-2 text-xs leading-relaxed text-white/60">
            <p id="disclaimer-heading" className="font-bold uppercase tracking-wider text-white/50">
              Disclaimer
            </p>
            <p>
              {siteInfo.siteName} promotes licensed operators where possible. Offers are subject to change and terms &amp; conditions from the operator apply.
            </p>
          </section>
          <div id="responsible" className="space-y-3">
            <h3 className="text-base font-bold text-white sm:text-lg">Responsible Gambling</h3>
            <div className="rounded-lg border border-white/10 bg-white/5 p-3 backdrop-blur-sm sm:p-4">
              <p className="mb-4 text-center text-xs leading-relaxed text-white/70 sm:text-sm sm:text-white/80">
                Play responsibly and only wager what you can afford to lose.
                If gambling becomes a problem, seek help from local support organizations.
              </p>
              <div className="flex flex-wrap items-center justify-center gap-2 sm:gap-3 md:gap-4">
                <a
                  href="https://www.begambleaware.org/"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="group flex items-center justify-center rounded-md bg-white/5 p-2 transition-all duration-300 hover:bg-white/10 hover:scale-105 sm:p-2.5"
                  title="BeGambleAware"
                >
                  <img
                    src="/footer_img/gambleaware.webp"
                    alt="BeGambleAware"
                    className="h-6 w-auto object-contain opacity-80 transition-opacity duration-300 group-hover:opacity-100 sm:h-7"
                  />
                </a>
                <a
                  href="https://www.raig.org/"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="group flex items-center justify-center rounded-md bg-white/5 p-2 transition-all duration-300 hover:bg-white/10 hover:scale-105 sm:p-2.5"
                  title="RAiG"
                >
                  <img
                    src="/footer_img/Raig.svg"
                    alt="RAiG"
                    className="h-6 w-auto object-contain opacity-80 transition-opacity duration-300 group-hover:opacity-100 sm:h-7"
                  />
                </a>
                <a
                  href="https://www.gamstop.co.uk/"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="group flex items-center justify-center rounded-md bg-white/5 p-2 transition-all duration-300 hover:bg-white/10 hover:scale-105 sm:p-2.5"
                  title="GAMSTOP"
                >
                  <img
                    src="/footer_img/gamstop.svg"
                    alt="GAMSTOP"
                    className="h-6 w-auto object-contain opacity-80 transition-opacity duration-300 group-hover:opacity-100 sm:h-7"
                  />
                </a>
                <a
                  href="https://www.gamcare.org.uk/"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="group flex items-center justify-center rounded-md bg-white/5 p-2 transition-all duration-300 hover:bg-white/10 hover:scale-105 sm:p-2.5"
                  title="GamCare"
                >
                  <img
                    src="/footer_img/gamecare.svg"
                    alt="GamCare"
                    className="h-6 w-auto object-contain opacity-80 transition-opacity duration-300 group-hover:opacity-100 sm:h-7"
                  />
                </a>
                <a
                  href="https://www.gamblingtherapy.org/"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="group flex items-center justify-center rounded-md bg-white/5 p-2 transition-all duration-300 hover:bg-white/10 hover:scale-105 sm:p-2.5"
                  title="Gambling Therapy"
                >
                  <img
                    src="/footer_img/gamblingtherapy.svg"
                    alt="Gambling Therapy"
                    className="h-6 w-auto object-contain opacity-80 transition-opacity duration-300 group-hover:opacity-100 sm:h-7"
                  />
                </a>
              </div>
              <div className="mt-4 flex items-center justify-center border-t border-white/10 pt-4">
                <img
                  src="/footer_img/18+.svg"
                  alt="18+ Only"
                  className="h-6 w-auto object-contain sm:h-7"
                />
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="border-t border-white/10 bg-slate-900/80">
        <div className="mx-auto max-w-6xl px-4 py-6 sm:px-6">
          <div className="mx-auto max-w-4xl rounded-2xl border-2 border-amber-500/40 bg-gradient-to-br from-amber-500/10 via-amber-500/5 to-transparent p-6 shadow-lg backdrop-blur-sm">
            <div className="flex items-start gap-4">
              <div className="flex-shrink-0">
                <div className="flex h-10 w-10 items-center justify-center rounded-full bg-amber-500/20">
                  <svg className="h-6 w-6 text-amber-400" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth={2}>
                    <path strokeLinecap="round" strokeLinejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                  </svg>
                </div>
              </div>
              <div className="flex-1 space-y-3">
                <div>
                  <h4 className="mb-2 text-sm font-bold text-amber-100 sm:text-base">
                    Important Notice
                  </h4>
                  <p className="text-xs leading-relaxed text-amber-50/90 sm:text-sm">
                    This site contains affiliate links. We may receive a commission if you sign up through our links. Please gamble responsibly and only bet what you can afford to lose. Gambling can be addictive. If you need help, contact{" "}
                    <a 
                      href="https://www.begambleaware.org" 
                      target="_blank" 
                      rel="noopener noreferrer"
                      className="font-semibold text-amber-200 underline decoration-amber-400/50 underline-offset-2 transition-colors hover:text-amber-100 hover:decoration-amber-300"
                    >
                      BeGambleAware
                    </a>
                    {" "}or{" "}
                    <a 
                      href="https://www.gamcare.org.uk" 
                      target="_blank" 
                      rel="noopener noreferrer"
                      className="font-semibold text-amber-200 underline decoration-amber-400/50 underline-offset-2 transition-colors hover:text-amber-100 hover:decoration-amber-300"
                    >
                      GamCare
                    </a>
                    .
        </p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div className="border-t border-white/5 py-4 text-center">
        <p className="text-xs text-white/60">
          © {new Date().getFullYear()} {siteInfo.siteName}. All rights reserved.
        </p>
        </div>
      </div>
    </footer>
  );
}
